using log4net;
using Microsoft.Azure.WebJobs;
using System;
using VA.PPMS.IWS.ProviderAgreementService.Interface;

namespace VA.PPMS.IWS.Functions
{
    public static class ProviderAgreementTimerTrigger
    {
        [FunctionName("ProviderAgreementTimerTrigger")]
        public static void Run([TimerTrigger("%ProviderAgreementTimerInterval%")] TimerInfo myTimer,
            [Inject] IProviderAgreementService providerAgreementService,
            [Inject] ILog logger)
        {
            try
            {
                providerAgreementService.ProcessData();
            }
            catch (Exception ex)
            {
                logger.Error($"There was a problem with ProviderAgreementTimerTrigger Processing at: {DateTime.Now}.", ex);
            }
        }
    }
}